/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.internal.Cleanly;
import org.openqa.selenium.internal.FileHandler;

public class Zip {
    private static final int BUF_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(File inputDir, File output) throws IOException {
        if (output.exists()) {
            throw new IOException("File already exists: " + output);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
            this.zip(inputDir, fos);
        }
        catch (Throwable throwable) {
            Cleanly.close(fos);
            throw throwable;
        }
        Cleanly.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zip(File inputDir) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.zip(inputDir, bos);
            String string = new Base64Encoder().encode(bos.toByteArray());
            return string;
        }
        finally {
            Cleanly.close(bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(File inputDir, OutputStream writeTo) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(writeTo);
            this.addToZip(inputDir.getAbsolutePath(), zos, inputDir);
        }
        catch (Throwable throwable) {
            Cleanly.close(zos);
            throw throwable;
        }
        Cleanly.close(zos);
    }

    private void addToZip(String basePath, ZipOutputStream zos, File toAdd) throws IOException {
        if (toAdd.isDirectory()) {
            for (File file : toAdd.listFiles()) {
                this.addToZip(basePath, zos, file);
            }
        } else {
            int len;
            FileInputStream fis = new FileInputStream(toAdd);
            String name = toAdd.getAbsolutePath().substring(basePath.length() + 1);
            ZipEntry entry = new ZipEntry(name);
            zos.putNextEntry(entry);
            byte[] buffer = new byte[4096];
            while ((len = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, len);
            }
            fis.close();
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(String source, File outputDir) throws IOException {
        byte[] bytes = new Base64Encoder().decode(source);
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            this.unzip(bis, outputDir);
        }
        catch (Throwable throwable) {
            Cleanly.close(bis);
            throw throwable;
        }
        Cleanly.close(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(File source, File outputDir) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            this.unzip(fis, outputDir);
        }
        catch (Throwable throwable) {
            Cleanly.close(fis);
            throw throwable;
        }
        Cleanly.close(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(InputStream source, File outputDir) throws IOException {
        ZipInputStream zis = new ZipInputStream(source);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    FileHandler.createDir(file);
                    continue;
                }
                this.unzipFile(outputDir, zis, entry.getName());
            }
        }
        finally {
            Cleanly.close(zis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzipFile(File output, InputStream zipStream, String name) throws IOException {
        File toWrite = new File(output, name);
        if (!FileHandler.createDir(toWrite.getParentFile())) {
            throw new IOException("Cannot create parent director for: " + name);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toWrite), 16384);
        try {
            int read;
            byte[] buffer = new byte[16384];
            while ((read = zipStream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }
}

