package org.openqa.selenium.devtools.v100.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS Supports at-rule descriptor.
 */
@org.openqa.selenium.Beta()
public class CSSSupports {

    private final java.lang.String text;

    private final java.util.Optional<org.openqa.selenium.devtools.v100.css.model.SourceRange> range;

    private final java.util.Optional<org.openqa.selenium.devtools.v100.css.model.StyleSheetId> styleSheetId;

    public CSSSupports(java.lang.String text, java.util.Optional<org.openqa.selenium.devtools.v100.css.model.SourceRange> range, java.util.Optional<org.openqa.selenium.devtools.v100.css.model.StyleSheetId> styleSheetId) {
        this.text = java.util.Objects.requireNonNull(text, "text is required");
        this.range = range;
        this.styleSheetId = styleSheetId;
    }

    /**
     * Supports rule text.
     */
    public java.lang.String getText() {
        return text;
    }

    /**
     * The associated rule header range in the enclosing stylesheet (if
     * available).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v100.css.model.SourceRange> getRange() {
        return range;
    }

    /**
     * Identifier of the stylesheet containing this object (if exists).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v100.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    private static CSSSupports fromJson(JsonInput input) {
        java.lang.String text = null;
        java.util.Optional<org.openqa.selenium.devtools.v100.css.model.SourceRange> range = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v100.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "text":
                    text = input.nextString();
                    break;
                case "range":
                    range = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v100.css.model.SourceRange.class));
                    break;
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v100.css.model.StyleSheetId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSSupports(text, range, styleSheetId);
    }
}
