package org.openqa.selenium.devtools.v100.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * WebSocket response data.
 */
public class WebSocketResponse {

    private final java.lang.Integer status;

    private final java.lang.String statusText;

    private final org.openqa.selenium.devtools.v100.network.model.Headers headers;

    private final java.util.Optional<java.lang.String> headersText;

    private final java.util.Optional<org.openqa.selenium.devtools.v100.network.model.Headers> requestHeaders;

    private final java.util.Optional<java.lang.String> requestHeadersText;

    public WebSocketResponse(java.lang.Integer status, java.lang.String statusText, org.openqa.selenium.devtools.v100.network.model.Headers headers, java.util.Optional<java.lang.String> headersText, java.util.Optional<org.openqa.selenium.devtools.v100.network.model.Headers> requestHeaders, java.util.Optional<java.lang.String> requestHeadersText) {
        this.status = java.util.Objects.requireNonNull(status, "status is required");
        this.statusText = java.util.Objects.requireNonNull(statusText, "statusText is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
        this.requestHeaders = requestHeaders;
        this.requestHeadersText = requestHeadersText;
    }

    /**
     * HTTP response status code.
     */
    public java.lang.Integer getStatus() {
        return status;
    }

    /**
     * HTTP response status text.
     */
    public java.lang.String getStatusText() {
        return statusText;
    }

    /**
     * HTTP response headers.
     */
    public org.openqa.selenium.devtools.v100.network.model.Headers getHeaders() {
        return headers;
    }

    /**
     * HTTP response headers text.
     */
    public java.util.Optional<java.lang.String> getHeadersText() {
        return headersText;
    }

    /**
     * HTTP request headers.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v100.network.model.Headers> getRequestHeaders() {
        return requestHeaders;
    }

    /**
     * HTTP request headers text.
     */
    public java.util.Optional<java.lang.String> getRequestHeadersText() {
        return requestHeadersText;
    }

    private static WebSocketResponse fromJson(JsonInput input) {
        java.lang.Integer status = 0;
        java.lang.String statusText = null;
        org.openqa.selenium.devtools.v100.network.model.Headers headers = null;
        java.util.Optional<java.lang.String> headersText = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v100.network.model.Headers> requestHeaders = java.util.Optional.empty();
        java.util.Optional<java.lang.String> requestHeadersText = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "status":
                    status = input.nextNumber().intValue();
                    break;
                case "statusText":
                    statusText = input.nextString();
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v100.network.model.Headers.class);
                    break;
                case "headersText":
                    headersText = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "requestHeaders":
                    requestHeaders = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v100.network.model.Headers.class));
                    break;
                case "requestHeadersText":
                    requestHeadersText = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WebSocketResponse(status, statusText, headers, headersText, requestHeaders, requestHeadersText);
    }
}
