/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v101.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum CookieSourceScheme {
    UNSET("Unset"),
    NONSECURE("NonSecure"),
    SECURE("Secure");

    private String value;

    private CookieSourceScheme(String value) {
        this.value = value;
    }

    public static CookieSourceScheme fromString(String s) {
        return Arrays.stream(CookieSourceScheme.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CookieSourceScheme "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CookieSourceScheme fromJson(JsonInput input) {
        return CookieSourceScheme.fromString(input.nextString());
    }
}

