/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v101.network.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v101.network.model.TrustTokenOperationType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class TrustTokenParams {
    private final TrustTokenOperationType type;
    private final RefreshPolicy refreshPolicy;
    private final Optional<List<String>> issuers;

    public TrustTokenParams(TrustTokenOperationType type, RefreshPolicy refreshPolicy, Optional<List<String>> issuers) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "refreshPolicy is required");
        this.issuers = issuers;
    }

    public TrustTokenOperationType getType() {
        return this.type;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public Optional<List<String>> getIssuers() {
        return this.issuers;
    }

    private static TrustTokenParams fromJson(JsonInput input) {
        TrustTokenOperationType type = null;
        RefreshPolicy refreshPolicy = null;
        Optional<List<String>> issuers = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (TrustTokenOperationType)((Object)input.read(TrustTokenOperationType.class));
                    continue block10;
                }
                case "refreshPolicy": {
                    refreshPolicy = RefreshPolicy.fromString(input.nextString());
                    continue block10;
                }
                case "issuers": {
                    issuers = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TrustTokenParams(type, refreshPolicy, issuers);
    }

    public static enum RefreshPolicy {
        USECACHED("UseCached"),
        REFRESH("Refresh");

        private String value;

        private RefreshPolicy(String value) {
            this.value = value;
        }

        public static RefreshPolicy fromString(String s) {
            return Arrays.stream(RefreshPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within RefreshPolicy "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static RefreshPolicy fromJson(JsonInput input) {
            return RefreshPolicy.fromString(input.nextString());
        }
    }
}

