/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v102.page.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v102.page.model.FrameId;
import org.openqa.selenium.devtools.v102.page.model.PrerenderFinalStatus;
import org.openqa.selenium.json.JsonInput;

public class PrerenderAttemptCompleted {
    private final FrameId initiatingFrameId;
    private final String prerenderingUrl;
    private final PrerenderFinalStatus finalStatus;

    public PrerenderAttemptCompleted(FrameId initiatingFrameId, String prerenderingUrl, PrerenderFinalStatus finalStatus) {
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.finalStatus = Objects.requireNonNull(finalStatus, "finalStatus is required");
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrerenderingUrl() {
        return this.prerenderingUrl;
    }

    public PrerenderFinalStatus getFinalStatus() {
        return this.finalStatus;
    }

    private static PrerenderAttemptCompleted fromJson(JsonInput input) {
        FrameId initiatingFrameId = null;
        String prerenderingUrl = null;
        PrerenderFinalStatus finalStatus = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "prerenderingUrl": {
                    prerenderingUrl = input.nextString();
                    continue block10;
                }
                case "finalStatus": {
                    finalStatus = (PrerenderFinalStatus)((Object)input.read(PrerenderFinalStatus.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderAttemptCompleted(initiatingFrameId, prerenderingUrl, finalStatus);
    }
}

