package org.openqa.selenium.devtools.v102.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum DeprecationIssueType {

    DEPRECATIONEXAMPLE("DeprecationExample"), UNTRANSLATED("Untranslated");

    private String value;

    DeprecationIssueType(String value) {
        this.value = value;
    }

    public static DeprecationIssueType fromString(String s) {
        return java.util.Arrays.stream(DeprecationIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DeprecationIssueType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DeprecationIssueType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
