/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v102.browser;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v102.browser.model.Bounds;
import org.openqa.selenium.devtools.v102.browser.model.BrowserCommandId;
import org.openqa.selenium.devtools.v102.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v102.browser.model.DownloadProgress;
import org.openqa.selenium.devtools.v102.browser.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v102.browser.model.Histogram;
import org.openqa.selenium.devtools.v102.browser.model.PermissionDescriptor;
import org.openqa.selenium.devtools.v102.browser.model.PermissionSetting;
import org.openqa.selenium.devtools.v102.browser.model.PermissionType;
import org.openqa.selenium.devtools.v102.browser.model.WindowID;
import org.openqa.selenium.devtools.v102.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class Browser {
    @Beta
    public static Command<Void> setPermission(PermissionDescriptor permission, PermissionSetting setting, Optional<String> origin, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(permission, "permission is required");
        Objects.requireNonNull(setting, "setting is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"permission", (Object)permission);
        params.put((Object)"setting", (Object)setting);
        origin.ifPresent(p -> params.put((Object)"origin", p));
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Browser.setPermission", (Map)params.build());
    }

    @Beta
    public static Command<Void> grantPermissions(List<PermissionType> permissions, Optional<String> origin, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(permissions, "permissions is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"permissions", permissions);
        origin.ifPresent(p -> params.put((Object)"origin", p));
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Browser.grantPermissions", (Map)params.build());
    }

    @Beta
    public static Command<Void> resetPermissions(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Browser.resetPermissions", (Map)params.build());
    }

    @Beta
    public static Command<Void> setDownloadBehavior(SetDownloadBehaviorBehavior behavior, Optional<BrowserContextID> browserContextId, Optional<String> downloadPath, Optional<Boolean> eventsEnabled) {
        Objects.requireNonNull(behavior, "behavior is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"behavior", (Object)behavior);
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        downloadPath.ifPresent(p -> params.put((Object)"downloadPath", p));
        eventsEnabled.ifPresent(p -> params.put((Object)"eventsEnabled", p));
        return new Command("Browser.setDownloadBehavior", (Map)params.build());
    }

    @Beta
    public static Command<Void> cancelDownload(String guid, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(guid, "guid is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"guid", (Object)guid);
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Browser.cancelDownload", (Map)params.build());
    }

    public static Command<Void> close() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Browser.close", (Map)params.build());
    }

    @Beta
    public static Command<Void> crash() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Browser.crash", (Map)params.build());
    }

    @Beta
    public static Command<Void> crashGpuProcess() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Browser.crashGpuProcess", (Map)params.build());
    }

    public static Command<GetVersionResponse> getVersion() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Browser.getVersion", (Map)params.build(), input -> (GetVersionResponse)input.read(GetVersionResponse.class));
    }

    @Beta
    public static Command<List<String>> getBrowserCommandLine() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Browser.getBrowserCommandLine", (Map)params.build(), ConverterFunctions.map((String)"arguments", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    @Beta
    public static Command<List<Histogram>> getHistograms(Optional<String> query, Optional<Boolean> delta) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        query.ifPresent(p -> params.put((Object)"query", p));
        delta.ifPresent(p -> params.put((Object)"delta", p));
        return new Command("Browser.getHistograms", (Map)params.build(), ConverterFunctions.map((String)"histograms", (Type)new TypeToken<List<Histogram>>(){}.getType()));
    }

    @Beta
    public static Command<Histogram> getHistogram(String name, Optional<Boolean> delta) {
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)name);
        delta.ifPresent(p -> params.put((Object)"delta", p));
        return new Command("Browser.getHistogram", (Map)params.build(), ConverterFunctions.map((String)"histogram", Histogram.class));
    }

    @Beta
    public static Command<Bounds> getWindowBounds(WindowID windowId) {
        Objects.requireNonNull(windowId, "windowId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"windowId", (Object)windowId);
        return new Command("Browser.getWindowBounds", (Map)params.build(), ConverterFunctions.map((String)"bounds", Bounds.class));
    }

    @Beta
    public static Command<GetWindowForTargetResponse> getWindowForTarget(Optional<TargetID> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        targetId.ifPresent(p -> params.put((Object)"targetId", p));
        return new Command("Browser.getWindowForTarget", (Map)params.build(), input -> (GetWindowForTargetResponse)input.read(GetWindowForTargetResponse.class));
    }

    @Beta
    public static Command<Void> setWindowBounds(WindowID windowId, Bounds bounds) {
        Objects.requireNonNull(windowId, "windowId is required");
        Objects.requireNonNull(bounds, "bounds is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"windowId", (Object)windowId);
        params.put((Object)"bounds", (Object)bounds);
        return new Command("Browser.setWindowBounds", (Map)params.build());
    }

    @Beta
    public static Command<Void> setDockTile(Optional<String> badgeLabel, Optional<String> image) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        badgeLabel.ifPresent(p -> params.put((Object)"badgeLabel", p));
        image.ifPresent(p -> params.put((Object)"image", p));
        return new Command("Browser.setDockTile", (Map)params.build());
    }

    @Beta
    public static Command<Void> executeBrowserCommand(BrowserCommandId commandId) {
        Objects.requireNonNull(commandId, "commandId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"commandId", (Object)commandId);
        return new Command("Browser.executeBrowserCommand", (Map)params.build());
    }

    public static Event<DownloadWillBegin> downloadWillBegin() {
        return new Event("Browser.downloadWillBegin", input -> (DownloadWillBegin)input.read(DownloadWillBegin.class));
    }

    public static Event<DownloadProgress> downloadProgress() {
        return new Event("Browser.downloadProgress", input -> (DownloadProgress)input.read(DownloadProgress.class));
    }

    public static class GetWindowForTargetResponse {
        private final WindowID windowId;
        private final Bounds bounds;

        public GetWindowForTargetResponse(WindowID windowId, Bounds bounds) {
            this.windowId = Objects.requireNonNull(windowId, "windowId is required");
            this.bounds = Objects.requireNonNull(bounds, "bounds is required");
        }

        public WindowID getWindowId() {
            return this.windowId;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        private static GetWindowForTargetResponse fromJson(JsonInput input) {
            WindowID windowId = null;
            Bounds bounds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "windowId": {
                        windowId = (WindowID)input.read(WindowID.class);
                        continue block8;
                    }
                    case "bounds": {
                        bounds = (Bounds)input.read(Bounds.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetWindowForTargetResponse(windowId, bounds);
        }
    }

    public static class GetVersionResponse {
        private final String protocolVersion;
        private final String product;
        private final String revision;
        private final String userAgent;
        private final String jsVersion;

        public GetVersionResponse(String protocolVersion, String product, String revision, String userAgent, String jsVersion) {
            this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion is required");
            this.product = Objects.requireNonNull(product, "product is required");
            this.revision = Objects.requireNonNull(revision, "revision is required");
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent is required");
            this.jsVersion = Objects.requireNonNull(jsVersion, "jsVersion is required");
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        public String getProduct() {
            return this.product;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getJsVersion() {
            return this.jsVersion;
        }

        private static GetVersionResponse fromJson(JsonInput input) {
            String protocolVersion = null;
            String product = null;
            String revision = null;
            String userAgent = null;
            String jsVersion = null;
            input.beginObject();
            block14: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "protocolVersion": {
                        protocolVersion = input.nextString();
                        continue block14;
                    }
                    case "product": {
                        product = input.nextString();
                        continue block14;
                    }
                    case "revision": {
                        revision = input.nextString();
                        continue block14;
                    }
                    case "userAgent": {
                        userAgent = input.nextString();
                        continue block14;
                    }
                    case "jsVersion": {
                        jsVersion = input.nextString();
                        continue block14;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetVersionResponse(protocolVersion, product, revision, userAgent, jsVersion);
        }
    }

    public static enum SetDownloadBehaviorBehavior {
        DENY("deny"),
        ALLOW("allow"),
        ALLOWANDNAME("allowAndName"),
        DEFAULT("default");

        private String value;

        private SetDownloadBehaviorBehavior(String value) {
            this.value = value;
        }

        public static SetDownloadBehaviorBehavior fromString(String s) {
            return Arrays.stream(SetDownloadBehaviorBehavior.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetDownloadBehaviorBehavior "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetDownloadBehaviorBehavior fromJson(JsonInput input) {
            return SetDownloadBehaviorBehavior.fromString(input.nextString());
        }
    }
}

