package org.openqa.selenium.devtools.v104.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class IsolationModeHighlightConfig {

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> resizerColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> resizerHandleColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> maskColor;

    public IsolationModeHighlightConfig(java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> resizerColor, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> resizerHandleColor, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> maskColor) {
        this.resizerColor = resizerColor;
        this.resizerHandleColor = resizerHandleColor;
        this.maskColor = maskColor;
    }

    /**
     * The fill color of the resizers (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> getResizerColor() {
        return resizerColor;
    }

    /**
     * The fill color for resizer handles (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> getResizerHandleColor() {
        return resizerHandleColor;
    }

    /**
     * The fill color for the mask covering non-isolated elements (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> getMaskColor() {
        return maskColor;
    }

    private static IsolationModeHighlightConfig fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> resizerColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> resizerHandleColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.RGBA> maskColor = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "resizerColor":
                    resizerColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.RGBA.class));
                    break;
                case "resizerHandleColor":
                    resizerHandleColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.RGBA.class));
                    break;
                case "maskColor":
                    maskColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.RGBA.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new IsolationModeHighlightConfig(resizerColor, resizerHandleColor, maskColor);
    }
}
