package org.openqa.selenium.devtools.v106.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a prerender attempt is completed.
 */
@org.openqa.selenium.Beta()
public class PrerenderAttemptCompleted {

    private final org.openqa.selenium.devtools.v106.page.model.FrameId initiatingFrameId;

    private final java.lang.String prerenderingUrl;

    private final org.openqa.selenium.devtools.v106.page.model.PrerenderFinalStatus finalStatus;

    private final java.util.Optional<java.lang.String> reasonDetails;

    public PrerenderAttemptCompleted(org.openqa.selenium.devtools.v106.page.model.FrameId initiatingFrameId, java.lang.String prerenderingUrl, org.openqa.selenium.devtools.v106.page.model.PrerenderFinalStatus finalStatus, java.util.Optional<java.lang.String> reasonDetails) {
        this.initiatingFrameId = java.util.Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = java.util.Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.finalStatus = java.util.Objects.requireNonNull(finalStatus, "finalStatus is required");
        this.reasonDetails = reasonDetails;
    }

    /**
     * The frame id of the frame initiating prerendering.
     */
    public org.openqa.selenium.devtools.v106.page.model.FrameId getInitiatingFrameId() {
        return initiatingFrameId;
    }

    public java.lang.String getPrerenderingUrl() {
        return prerenderingUrl;
    }

    public org.openqa.selenium.devtools.v106.page.model.PrerenderFinalStatus getFinalStatus() {
        return finalStatus;
    }

    /**
     * This is used to give users more information about the cancellation details,
     * and this will be formatted for display.
     */
    public java.util.Optional<java.lang.String> getReasonDetails() {
        return reasonDetails;
    }

    private static PrerenderAttemptCompleted fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v106.page.model.FrameId initiatingFrameId = null;
        java.lang.String prerenderingUrl = null;
        org.openqa.selenium.devtools.v106.page.model.PrerenderFinalStatus finalStatus = null;
        java.util.Optional<java.lang.String> reasonDetails = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "initiatingFrameId":
                    initiatingFrameId = input.read(org.openqa.selenium.devtools.v106.page.model.FrameId.class);
                    break;
                case "prerenderingUrl":
                    prerenderingUrl = input.nextString();
                    break;
                case "finalStatus":
                    finalStatus = input.read(org.openqa.selenium.devtools.v106.page.model.PrerenderFinalStatus.class);
                    break;
                case "reasonDetails":
                    reasonDetails = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrerenderAttemptCompleted(initiatingFrameId, prerenderingUrl, finalStatus, reasonDetails);
    }
}
