package org.openqa.selenium.devtools.v107.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when request for resources within a .wbn file failed.
 */
@org.openqa.selenium.Beta()
public class SubresourceWebBundleInnerResponseError {

    private final org.openqa.selenium.devtools.v107.network.model.RequestId innerRequestId;

    private final java.lang.String innerRequestURL;

    private final java.lang.String errorMessage;

    private final java.util.Optional<org.openqa.selenium.devtools.v107.network.model.RequestId> bundleRequestId;

    public SubresourceWebBundleInnerResponseError(org.openqa.selenium.devtools.v107.network.model.RequestId innerRequestId, java.lang.String innerRequestURL, java.lang.String errorMessage, java.util.Optional<org.openqa.selenium.devtools.v107.network.model.RequestId> bundleRequestId) {
        this.innerRequestId = java.util.Objects.requireNonNull(innerRequestId, "innerRequestId is required");
        this.innerRequestURL = java.util.Objects.requireNonNull(innerRequestURL, "innerRequestURL is required");
        this.errorMessage = java.util.Objects.requireNonNull(errorMessage, "errorMessage is required");
        this.bundleRequestId = bundleRequestId;
    }

    /**
     * Request identifier of the subresource request
     */
    public org.openqa.selenium.devtools.v107.network.model.RequestId getInnerRequestId() {
        return innerRequestId;
    }

    /**
     * URL of the subresource resource.
     */
    public java.lang.String getInnerRequestURL() {
        return innerRequestURL;
    }

    /**
     * Error message
     */
    public java.lang.String getErrorMessage() {
        return errorMessage;
    }

    /**
     * Bundle request identifier. Used to match this information to another event.
     * This made be absent in case when the instrumentation was enabled only
     * after webbundle was parsed.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v107.network.model.RequestId> getBundleRequestId() {
        return bundleRequestId;
    }

    private static SubresourceWebBundleInnerResponseError fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v107.network.model.RequestId innerRequestId = null;
        java.lang.String innerRequestURL = null;
        java.lang.String errorMessage = null;
        java.util.Optional<org.openqa.selenium.devtools.v107.network.model.RequestId> bundleRequestId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "innerRequestId":
                    innerRequestId = input.read(org.openqa.selenium.devtools.v107.network.model.RequestId.class);
                    break;
                case "innerRequestURL":
                    innerRequestURL = input.nextString();
                    break;
                case "errorMessage":
                    errorMessage = input.nextString();
                    break;
                case "bundleRequestId":
                    bundleRequestId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v107.network.model.RequestId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SubresourceWebBundleInnerResponseError(innerRequestId, innerRequestURL, errorMessage, bundleRequestId);
    }
}
