package org.openqa.selenium.devtools.v109.domdebugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSP Violation type.
 */
@org.openqa.selenium.Beta()
public enum CSPViolationType {

    TRUSTEDTYPE_SINK_VIOLATION("trustedtype-sink-violation"), TRUSTEDTYPE_POLICY_VIOLATION("trustedtype-policy-violation");

    private String value;

    CSPViolationType(String value) {
        this.value = value;
    }

    public static CSPViolationType fromString(String s) {
        return java.util.Arrays.stream(CSPViolationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CSPViolationType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CSPViolationType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
