/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v109.storage.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v109.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v109.storage.model.InterestGroupAd;
import org.openqa.selenium.json.JsonInput;

public class InterestGroupDetails {
    private final String ownerOrigin;
    private final String name;
    private final TimeSinceEpoch expirationTime;
    private final String joiningOrigin;
    private final Optional<String> biddingUrl;
    private final Optional<String> biddingWasmHelperUrl;
    private final Optional<String> updateUrl;
    private final Optional<String> trustedBiddingSignalsUrl;
    private final List<String> trustedBiddingSignalsKeys;
    private final Optional<String> userBiddingSignals;
    private final List<InterestGroupAd> ads;
    private final List<InterestGroupAd> adComponents;

    public InterestGroupDetails(String ownerOrigin, String name, TimeSinceEpoch expirationTime, String joiningOrigin, Optional<String> biddingUrl, Optional<String> biddingWasmHelperUrl, Optional<String> updateUrl, Optional<String> trustedBiddingSignalsUrl, List<String> trustedBiddingSignalsKeys, Optional<String> userBiddingSignals, List<InterestGroupAd> ads, List<InterestGroupAd> adComponents) {
        this.ownerOrigin = Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime is required");
        this.joiningOrigin = Objects.requireNonNull(joiningOrigin, "joiningOrigin is required");
        this.biddingUrl = biddingUrl;
        this.biddingWasmHelperUrl = biddingWasmHelperUrl;
        this.updateUrl = updateUrl;
        this.trustedBiddingSignalsUrl = trustedBiddingSignalsUrl;
        this.trustedBiddingSignalsKeys = Objects.requireNonNull(trustedBiddingSignalsKeys, "trustedBiddingSignalsKeys is required");
        this.userBiddingSignals = userBiddingSignals;
        this.ads = Objects.requireNonNull(ads, "ads is required");
        this.adComponents = Objects.requireNonNull(adComponents, "adComponents is required");
    }

    public String getOwnerOrigin() {
        return this.ownerOrigin;
    }

    public String getName() {
        return this.name;
    }

    public TimeSinceEpoch getExpirationTime() {
        return this.expirationTime;
    }

    public String getJoiningOrigin() {
        return this.joiningOrigin;
    }

    public Optional<String> getBiddingUrl() {
        return this.biddingUrl;
    }

    public Optional<String> getBiddingWasmHelperUrl() {
        return this.biddingWasmHelperUrl;
    }

    public Optional<String> getUpdateUrl() {
        return this.updateUrl;
    }

    public Optional<String> getTrustedBiddingSignalsUrl() {
        return this.trustedBiddingSignalsUrl;
    }

    public List<String> getTrustedBiddingSignalsKeys() {
        return this.trustedBiddingSignalsKeys;
    }

    public Optional<String> getUserBiddingSignals() {
        return this.userBiddingSignals;
    }

    public List<InterestGroupAd> getAds() {
        return this.ads;
    }

    public List<InterestGroupAd> getAdComponents() {
        return this.adComponents;
    }

    private static InterestGroupDetails fromJson(JsonInput input) {
        String ownerOrigin = null;
        String name = null;
        TimeSinceEpoch expirationTime = null;
        String joiningOrigin = null;
        Optional<String> biddingUrl = Optional.empty();
        Optional<String> biddingWasmHelperUrl = Optional.empty();
        Optional<String> updateUrl = Optional.empty();
        Optional<String> trustedBiddingSignalsUrl = Optional.empty();
        List trustedBiddingSignalsKeys = null;
        Optional<String> userBiddingSignals = Optional.empty();
        List ads = null;
        List adComponents = null;
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "ownerOrigin": {
                    ownerOrigin = input.nextString();
                    continue block28;
                }
                case "name": {
                    name = input.nextString();
                    continue block28;
                }
                case "expirationTime": {
                    expirationTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block28;
                }
                case "joiningOrigin": {
                    joiningOrigin = input.nextString();
                    continue block28;
                }
                case "biddingUrl": {
                    biddingUrl = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "biddingWasmHelperUrl": {
                    biddingWasmHelperUrl = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "updateUrl": {
                    updateUrl = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "trustedBiddingSignalsUrl": {
                    trustedBiddingSignalsUrl = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "trustedBiddingSignalsKeys": {
                    trustedBiddingSignalsKeys = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block28;
                }
                case "userBiddingSignals": {
                    userBiddingSignals = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "ads": {
                    ads = (List)input.read(new TypeToken<List<InterestGroupAd>>(){}.getType());
                    continue block28;
                }
                case "adComponents": {
                    adComponents = (List)input.read(new TypeToken<List<InterestGroupAd>>(){}.getType());
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InterestGroupDetails(ownerOrigin, name, expirationTime, joiningOrigin, biddingUrl, biddingWasmHelperUrl, updateUrl, trustedBiddingSignalsUrl, trustedBiddingSignalsKeys, userBiddingSignals, ads, adComponents);
    }
}

