package org.openqa.selenium.devtools.v109.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Ad advertising element inside an interest group.
 */
public class InterestGroupAd {

    private final java.lang.String renderUrl;

    private final java.util.Optional<java.lang.String> metadata;

    public InterestGroupAd(java.lang.String renderUrl, java.util.Optional<java.lang.String> metadata) {
        this.renderUrl = java.util.Objects.requireNonNull(renderUrl, "renderUrl is required");
        this.metadata = metadata;
    }

    public java.lang.String getRenderUrl() {
        return renderUrl;
    }

    public java.util.Optional<java.lang.String> getMetadata() {
        return metadata;
    }

    private static InterestGroupAd fromJson(JsonInput input) {
        java.lang.String renderUrl = null;
        java.util.Optional<java.lang.String> metadata = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "renderUrl":
                    renderUrl = input.nextString();
                    break;
                case "metadata":
                    metadata = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InterestGroupAd(renderUrl, metadata);
    }
}
