/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v109.page.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum ReferrerPolicy {
    NOREFERRER("noReferrer"),
    NOREFERRERWHENDOWNGRADE("noReferrerWhenDowngrade"),
    ORIGIN("origin"),
    ORIGINWHENCROSSORIGIN("originWhenCrossOrigin"),
    SAMEORIGIN("sameOrigin"),
    STRICTORIGIN("strictOrigin"),
    STRICTORIGINWHENCROSSORIGIN("strictOriginWhenCrossOrigin"),
    UNSAFEURL("unsafeUrl");

    private String value;

    private ReferrerPolicy(String value) {
        this.value = value;
    }

    public static ReferrerPolicy fromString(String s) {
        return Arrays.stream(ReferrerPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ReferrerPolicy "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ReferrerPolicy fromJson(JsonInput input) {
        return ReferrerPolicy.fromString(input.nextString());
    }
}

