/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.input;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v110.input.model.DragData;
import org.openqa.selenium.devtools.v110.input.model.GestureSourceType;
import org.openqa.selenium.devtools.v110.input.model.MouseButton;
import org.openqa.selenium.devtools.v110.input.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v110.input.model.TouchPoint;
import org.openqa.selenium.json.JsonInput;

public class Input {
    @Beta
    public static Command<Void> dispatchDragEvent(DispatchDragEventType type, Number x, Number y, DragData data, Optional<Integer> modifiers) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(data, "data is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"type", (Object)type);
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        params.put((Object)"data", (Object)data);
        modifiers.ifPresent(p -> params.put((Object)"modifiers", p));
        return new Command("Input.dispatchDragEvent", (Map)params.build());
    }

    public static Command<Void> dispatchKeyEvent(DispatchKeyEventType type, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp, Optional<String> text, Optional<String> unmodifiedText, Optional<String> keyIdentifier, Optional<String> code, Optional<String> key, Optional<Integer> windowsVirtualKeyCode, Optional<Integer> nativeVirtualKeyCode, Optional<Boolean> autoRepeat, Optional<Boolean> isKeypad, Optional<Boolean> isSystemKey, Optional<Integer> location, Optional<List<String>> commands) {
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"type", (Object)type);
        modifiers.ifPresent(p -> params.put((Object)"modifiers", p));
        timestamp.ifPresent(p -> params.put((Object)"timestamp", p));
        text.ifPresent(p -> params.put((Object)"text", p));
        unmodifiedText.ifPresent(p -> params.put((Object)"unmodifiedText", p));
        keyIdentifier.ifPresent(p -> params.put((Object)"keyIdentifier", p));
        code.ifPresent(p -> params.put((Object)"code", p));
        key.ifPresent(p -> params.put((Object)"key", p));
        windowsVirtualKeyCode.ifPresent(p -> params.put((Object)"windowsVirtualKeyCode", p));
        nativeVirtualKeyCode.ifPresent(p -> params.put((Object)"nativeVirtualKeyCode", p));
        autoRepeat.ifPresent(p -> params.put((Object)"autoRepeat", p));
        isKeypad.ifPresent(p -> params.put((Object)"isKeypad", p));
        isSystemKey.ifPresent(p -> params.put((Object)"isSystemKey", p));
        location.ifPresent(p -> params.put((Object)"location", p));
        commands.ifPresent(p -> params.put((Object)"commands", p));
        return new Command("Input.dispatchKeyEvent", (Map)params.build());
    }

    @Beta
    public static Command<Void> insertText(String text) {
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"text", (Object)text);
        return new Command("Input.insertText", (Map)params.build());
    }

    @Beta
    public static Command<Void> imeSetComposition(String text, Integer selectionStart, Integer selectionEnd, Optional<Integer> replacementStart, Optional<Integer> replacementEnd) {
        Objects.requireNonNull(text, "text is required");
        Objects.requireNonNull(selectionStart, "selectionStart is required");
        Objects.requireNonNull(selectionEnd, "selectionEnd is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"text", (Object)text);
        params.put((Object)"selectionStart", (Object)selectionStart);
        params.put((Object)"selectionEnd", (Object)selectionEnd);
        replacementStart.ifPresent(p -> params.put((Object)"replacementStart", p));
        replacementEnd.ifPresent(p -> params.put((Object)"replacementEnd", p));
        return new Command("Input.imeSetComposition", (Map)params.build());
    }

    public static Command<Void> dispatchMouseEvent(DispatchMouseEventType type, Number x, Number y, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp, Optional<MouseButton> button, Optional<Integer> buttons, Optional<Integer> clickCount, Optional<Number> force, Optional<Number> tangentialPressure, Optional<Integer> tiltX, Optional<Integer> tiltY, Optional<Integer> twist, Optional<Number> deltaX, Optional<Number> deltaY, Optional<DispatchMouseEventPointerType> pointerType) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"type", (Object)type);
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        modifiers.ifPresent(p -> params.put((Object)"modifiers", p));
        timestamp.ifPresent(p -> params.put((Object)"timestamp", p));
        button.ifPresent(p -> params.put((Object)"button", (Object)p));
        buttons.ifPresent(p -> params.put((Object)"buttons", p));
        clickCount.ifPresent(p -> params.put((Object)"clickCount", p));
        force.ifPresent(p -> params.put((Object)"force", p));
        tangentialPressure.ifPresent(p -> params.put((Object)"tangentialPressure", p));
        tiltX.ifPresent(p -> params.put((Object)"tiltX", p));
        tiltY.ifPresent(p -> params.put((Object)"tiltY", p));
        twist.ifPresent(p -> params.put((Object)"twist", p));
        deltaX.ifPresent(p -> params.put((Object)"deltaX", p));
        deltaY.ifPresent(p -> params.put((Object)"deltaY", p));
        pointerType.ifPresent(p -> params.put((Object)"pointerType", (Object)p));
        return new Command("Input.dispatchMouseEvent", (Map)params.build());
    }

    public static Command<Void> dispatchTouchEvent(DispatchTouchEventType type, List<TouchPoint> touchPoints, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(touchPoints, "touchPoints is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"type", (Object)type);
        params.put((Object)"touchPoints", touchPoints);
        modifiers.ifPresent(p -> params.put((Object)"modifiers", p));
        timestamp.ifPresent(p -> params.put((Object)"timestamp", p));
        return new Command("Input.dispatchTouchEvent", (Map)params.build());
    }

    @Beta
    public static Command<Void> emulateTouchFromMouseEvent(EmulateTouchFromMouseEventType type, Integer x, Integer y, MouseButton button, Optional<TimeSinceEpoch> timestamp, Optional<Number> deltaX, Optional<Number> deltaY, Optional<Integer> modifiers, Optional<Integer> clickCount) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(button, "button is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"type", (Object)type);
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        params.put((Object)"button", (Object)button);
        timestamp.ifPresent(p -> params.put((Object)"timestamp", p));
        deltaX.ifPresent(p -> params.put((Object)"deltaX", p));
        deltaY.ifPresent(p -> params.put((Object)"deltaY", p));
        modifiers.ifPresent(p -> params.put((Object)"modifiers", p));
        clickCount.ifPresent(p -> params.put((Object)"clickCount", p));
        return new Command("Input.emulateTouchFromMouseEvent", (Map)params.build());
    }

    public static Command<Void> setIgnoreInputEvents(Boolean ignore) {
        Objects.requireNonNull(ignore, "ignore is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ignore", (Object)ignore);
        return new Command("Input.setIgnoreInputEvents", (Map)params.build());
    }

    @Beta
    public static Command<Void> setInterceptDrags(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command("Input.setInterceptDrags", (Map)params.build());
    }

    @Beta
    public static Command<Void> synthesizePinchGesture(Number x, Number y, Number scaleFactor, Optional<Integer> relativeSpeed, Optional<GestureSourceType> gestureSourceType) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(scaleFactor, "scaleFactor is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        params.put((Object)"scaleFactor", (Object)scaleFactor);
        relativeSpeed.ifPresent(p -> params.put((Object)"relativeSpeed", p));
        gestureSourceType.ifPresent(p -> params.put((Object)"gestureSourceType", (Object)p));
        return new Command("Input.synthesizePinchGesture", (Map)params.build());
    }

    @Beta
    public static Command<Void> synthesizeScrollGesture(Number x, Number y, Optional<Number> xDistance, Optional<Number> yDistance, Optional<Number> xOverscroll, Optional<Number> yOverscroll, Optional<Boolean> preventFling, Optional<Integer> speed, Optional<GestureSourceType> gestureSourceType, Optional<Integer> repeatCount, Optional<Integer> repeatDelayMs, Optional<String> interactionMarkerName) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        xDistance.ifPresent(p -> params.put((Object)"xDistance", p));
        yDistance.ifPresent(p -> params.put((Object)"yDistance", p));
        xOverscroll.ifPresent(p -> params.put((Object)"xOverscroll", p));
        yOverscroll.ifPresent(p -> params.put((Object)"yOverscroll", p));
        preventFling.ifPresent(p -> params.put((Object)"preventFling", p));
        speed.ifPresent(p -> params.put((Object)"speed", p));
        gestureSourceType.ifPresent(p -> params.put((Object)"gestureSourceType", (Object)p));
        repeatCount.ifPresent(p -> params.put((Object)"repeatCount", p));
        repeatDelayMs.ifPresent(p -> params.put((Object)"repeatDelayMs", p));
        interactionMarkerName.ifPresent(p -> params.put((Object)"interactionMarkerName", p));
        return new Command("Input.synthesizeScrollGesture", (Map)params.build());
    }

    @Beta
    public static Command<Void> synthesizeTapGesture(Number x, Number y, Optional<Integer> duration, Optional<Integer> tapCount, Optional<GestureSourceType> gestureSourceType) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        duration.ifPresent(p -> params.put((Object)"duration", p));
        tapCount.ifPresent(p -> params.put((Object)"tapCount", p));
        gestureSourceType.ifPresent(p -> params.put((Object)"gestureSourceType", (Object)p));
        return new Command("Input.synthesizeTapGesture", (Map)params.build());
    }

    public static Event<DragData> dragIntercepted() {
        return new Event("Input.dragIntercepted", ConverterFunctions.map((String)"data", DragData.class));
    }

    public static enum EmulateTouchFromMouseEventType {
        MOUSEPRESSED("mousePressed"),
        MOUSERELEASED("mouseReleased"),
        MOUSEMOVED("mouseMoved"),
        MOUSEWHEEL("mouseWheel");

        private String value;

        private EmulateTouchFromMouseEventType(String value) {
            this.value = value;
        }

        public static EmulateTouchFromMouseEventType fromString(String s) {
            return Arrays.stream(EmulateTouchFromMouseEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within EmulateTouchFromMouseEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EmulateTouchFromMouseEventType fromJson(JsonInput input) {
            return EmulateTouchFromMouseEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchTouchEventType {
        TOUCHSTART("touchStart"),
        TOUCHEND("touchEnd"),
        TOUCHMOVE("touchMove"),
        TOUCHCANCEL("touchCancel");

        private String value;

        private DispatchTouchEventType(String value) {
            this.value = value;
        }

        public static DispatchTouchEventType fromString(String s) {
            return Arrays.stream(DispatchTouchEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchTouchEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchTouchEventType fromJson(JsonInput input) {
            return DispatchTouchEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchMouseEventPointerType {
        MOUSE("mouse"),
        PEN("pen");

        private String value;

        private DispatchMouseEventPointerType(String value) {
            this.value = value;
        }

        public static DispatchMouseEventPointerType fromString(String s) {
            return Arrays.stream(DispatchMouseEventPointerType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchMouseEventPointerType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchMouseEventPointerType fromJson(JsonInput input) {
            return DispatchMouseEventPointerType.fromString(input.nextString());
        }
    }

    public static enum DispatchMouseEventType {
        MOUSEPRESSED("mousePressed"),
        MOUSERELEASED("mouseReleased"),
        MOUSEMOVED("mouseMoved"),
        MOUSEWHEEL("mouseWheel");

        private String value;

        private DispatchMouseEventType(String value) {
            this.value = value;
        }

        public static DispatchMouseEventType fromString(String s) {
            return Arrays.stream(DispatchMouseEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchMouseEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchMouseEventType fromJson(JsonInput input) {
            return DispatchMouseEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchKeyEventType {
        KEYDOWN("keyDown"),
        KEYUP("keyUp"),
        RAWKEYDOWN("rawKeyDown"),
        CHAR("char");

        private String value;

        private DispatchKeyEventType(String value) {
            this.value = value;
        }

        public static DispatchKeyEventType fromString(String s) {
            return Arrays.stream(DispatchKeyEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchKeyEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchKeyEventType fromJson(JsonInput input) {
            return DispatchKeyEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchDragEventType {
        DRAGENTER("dragEnter"),
        DRAGOVER("dragOver"),
        DROP("drop"),
        DRAGCANCEL("dragCancel");

        private String value;

        private DispatchDragEventType(String value) {
            this.value = value;
        }

        public static DispatchDragEventType fromString(String s) {
            return Arrays.stream(DispatchDragEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchDragEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchDragEventType fromJson(JsonInput input) {
            return DispatchDragEventType.fromString(input.nextString());
        }
    }
}

