package org.openqa.selenium.devtools.v110.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum ClientNavigationDisposition {

    CURRENTTAB("currentTab"), NEWTAB("newTab"), NEWWINDOW("newWindow"), DOWNLOAD("download");

    private String value;

    ClientNavigationDisposition(String value) {
        this.value = value;
    }

    public static ClientNavigationDisposition fromString(String s) {
        return java.util.Arrays.stream(ClientNavigationDisposition.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ClientNavigationDisposition "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ClientNavigationDisposition fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
