package org.openqa.selenium.devtools.v110.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Debug symbols available for a wasm script.
 */
public class DebugSymbols {

    public enum Type {

        NONE("None"), SOURCEMAP("SourceMap"), EMBEDDEDDWARF("EmbeddedDWARF"), EXTERNALDWARF("ExternalDWARF");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Type type;

    private final java.util.Optional<java.lang.String> externalURL;

    public DebugSymbols(Type type, java.util.Optional<java.lang.String> externalURL) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.externalURL = externalURL;
    }

    /**
     * Type of the debug symbols.
     */
    public Type getType() {
        return type;
    }

    /**
     * URL of the external symbol source.
     */
    public java.util.Optional<java.lang.String> getExternalURL() {
        return externalURL;
    }

    private static DebugSymbols fromJson(JsonInput input) {
        Type type = null;
        java.util.Optional<java.lang.String> externalURL = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = Type.fromString(input.nextString());
                    break;
                case "externalURL":
                    externalURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DebugSymbols(type, externalURL);
    }
}
