/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.dom.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v110.dom.model.Quad;
import org.openqa.selenium.devtools.v110.dom.model.ShapeOutsideInfo;
import org.openqa.selenium.json.JsonInput;

public class BoxModel {
    private final Quad content;
    private final Quad padding;
    private final Quad border;
    private final Quad margin;
    private final Integer width;
    private final Integer height;
    private final Optional<ShapeOutsideInfo> shapeOutside;

    public BoxModel(Quad content, Quad padding, Quad border, Quad margin, Integer width, Integer height, Optional<ShapeOutsideInfo> shapeOutside) {
        this.content = Objects.requireNonNull(content, "content is required");
        this.padding = Objects.requireNonNull(padding, "padding is required");
        this.border = Objects.requireNonNull(border, "border is required");
        this.margin = Objects.requireNonNull(margin, "margin is required");
        this.width = Objects.requireNonNull(width, "width is required");
        this.height = Objects.requireNonNull(height, "height is required");
        this.shapeOutside = shapeOutside;
    }

    public Quad getContent() {
        return this.content;
    }

    public Quad getPadding() {
        return this.padding;
    }

    public Quad getBorder() {
        return this.border;
    }

    public Quad getMargin() {
        return this.margin;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Optional<ShapeOutsideInfo> getShapeOutside() {
        return this.shapeOutside;
    }

    private static BoxModel fromJson(JsonInput input) {
        Quad content = null;
        Quad padding = null;
        Quad border = null;
        Quad margin = null;
        Integer width = 0;
        Integer height = 0;
        Optional<ShapeOutsideInfo> shapeOutside = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "content": {
                    content = (Quad)input.read(Quad.class);
                    continue block18;
                }
                case "padding": {
                    padding = (Quad)input.read(Quad.class);
                    continue block18;
                }
                case "border": {
                    border = (Quad)input.read(Quad.class);
                    continue block18;
                }
                case "margin": {
                    margin = (Quad)input.read(Quad.class);
                    continue block18;
                }
                case "width": {
                    width = input.nextNumber().intValue();
                    continue block18;
                }
                case "height": {
                    height = input.nextNumber().intValue();
                    continue block18;
                }
                case "shapeOutside": {
                    shapeOutside = Optional.ofNullable((ShapeOutsideInfo)input.read(ShapeOutsideInfo.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BoxModel(content, padding, border, margin, width, height, shapeOutside);
    }
}

