package org.openqa.selenium.devtools.v112.preload;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Preload {

    public static Command<Void> enable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Preload.enable", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Preload.disable", params.build());
    }

    public static Event<org.openqa.selenium.devtools.v112.preload.model.RuleSet> ruleSetUpdated() {
        return new Event<>("Preload.ruleSetUpdated", ConverterFunctions.map("ruleSet", org.openqa.selenium.devtools.v112.preload.model.RuleSet.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.preload.model.RuleSetId> ruleSetRemoved() {
        return new Event<>("Preload.ruleSetRemoved", ConverterFunctions.map("id", org.openqa.selenium.devtools.v112.preload.model.RuleSetId.class));
    }
}
