/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.preload.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v112.network.model.LoaderId;
import org.openqa.selenium.devtools.v112.preload.model.RuleSetId;
import org.openqa.selenium.json.JsonInput;

public class RuleSet {
    private final RuleSetId id;
    private final LoaderId loaderId;
    private final String sourceText;

    public RuleSet(RuleSetId id, LoaderId loaderId, String sourceText) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.sourceText = Objects.requireNonNull(sourceText, "sourceText is required");
    }

    public RuleSetId getId() {
        return this.id;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    private static RuleSet fromJson(JsonInput input) {
        RuleSetId id = null;
        LoaderId loaderId = null;
        String sourceText = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (RuleSetId)input.read(RuleSetId.class);
                    continue block10;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block10;
                }
                case "sourceText": {
                    sourceText = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RuleSet(id, loaderId, sourceText);
    }
}

