package org.openqa.selenium.devtools.v114.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of possible script languages.
 */
public enum ScriptLanguage {

    JAVASCRIPT("JavaScript"), WEBASSEMBLY("WebAssembly");

    private String value;

    ScriptLanguage(String value) {
        this.value = value;
    }

    public static ScriptLanguage fromString(String s) {
        return java.util.Arrays.stream(ScriptLanguage.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ScriptLanguage "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ScriptLanguage fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
