package org.openqa.selenium.devtools.v115.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * One of the interest groups was accessed by the associated page.
 */
public class InterestGroupAccessed {

    private final org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch accessTime;

    private final org.openqa.selenium.devtools.v115.storage.model.InterestGroupAccessType type;

    private final java.lang.String ownerOrigin;

    private final java.lang.String name;

    public InterestGroupAccessed(org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch accessTime, org.openqa.selenium.devtools.v115.storage.model.InterestGroupAccessType type, java.lang.String ownerOrigin, java.lang.String name) {
        this.accessTime = java.util.Objects.requireNonNull(accessTime, "accessTime is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.ownerOrigin = java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
    }

    public org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch getAccessTime() {
        return accessTime;
    }

    public org.openqa.selenium.devtools.v115.storage.model.InterestGroupAccessType getType() {
        return type;
    }

    public java.lang.String getOwnerOrigin() {
        return ownerOrigin;
    }

    public java.lang.String getName() {
        return name;
    }

    private static InterestGroupAccessed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch accessTime = null;
        org.openqa.selenium.devtools.v115.storage.model.InterestGroupAccessType type = null;
        java.lang.String ownerOrigin = null;
        java.lang.String name = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "accessTime":
                    accessTime = input.read(org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch.class);
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v115.storage.model.InterestGroupAccessType.class);
                    break;
                case "ownerOrigin":
                    ownerOrigin = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InterestGroupAccessed(accessTime, type, ownerOrigin, name);
    }
}
