/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v117.css.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class SourceRange {
    private final Integer startLine;
    private final Integer startColumn;
    private final Integer endLine;
    private final Integer endColumn;

    public SourceRange(Integer startLine, Integer startColumn, Integer endLine, Integer endColumn) {
        this.startLine = Objects.requireNonNull(startLine, "startLine is required");
        this.startColumn = Objects.requireNonNull(startColumn, "startColumn is required");
        this.endLine = Objects.requireNonNull(endLine, "endLine is required");
        this.endColumn = Objects.requireNonNull(endColumn, "endColumn is required");
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public Integer getStartColumn() {
        return this.startColumn;
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public Integer getEndColumn() {
        return this.endColumn;
    }

    private static SourceRange fromJson(JsonInput input) {
        Integer startLine = 0;
        Integer startColumn = 0;
        Integer endLine = 0;
        Integer endColumn = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "startLine": {
                    startLine = input.nextNumber().intValue();
                    continue block12;
                }
                case "startColumn": {
                    startColumn = input.nextNumber().intValue();
                    continue block12;
                }
                case "endLine": {
                    endLine = input.nextNumber().intValue();
                    continue block12;
                }
                case "endColumn": {
                    endColumn = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SourceRange(startLine, startColumn, endLine, endColumn);
    }
}

