/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v117.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v117.network.model.LoaderId;
import org.openqa.selenium.devtools.v117.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v117.network.model.RequestId;
import org.openqa.selenium.devtools.v117.network.model.ResourceType;
import org.openqa.selenium.devtools.v117.network.model.Response;
import org.openqa.selenium.devtools.v117.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class ResponseReceived {
    private final RequestId requestId;
    private final LoaderId loaderId;
    private final MonotonicTime timestamp;
    private final ResourceType type;
    private final Response response;
    private final Boolean hasExtraInfo;
    private final Optional<FrameId> frameId;

    public ResponseReceived(RequestId requestId, LoaderId loaderId, MonotonicTime timestamp, ResourceType type, Response response, Boolean hasExtraInfo, Optional<FrameId> frameId) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.response = Objects.requireNonNull(response, "response is required");
        this.hasExtraInfo = Objects.requireNonNull(hasExtraInfo, "hasExtraInfo is required");
        this.frameId = frameId;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public ResourceType getType() {
        return this.type;
    }

    public Response getResponse() {
        return this.response;
    }

    @Beta
    public Boolean getHasExtraInfo() {
        return this.hasExtraInfo;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    private static ResponseReceived fromJson(JsonInput input) {
        RequestId requestId = null;
        LoaderId loaderId = null;
        MonotonicTime timestamp = null;
        ResourceType type = null;
        Response response = null;
        Boolean hasExtraInfo = false;
        Optional<FrameId> frameId = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block18;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block18;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block18;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block18;
                }
                case "response": {
                    response = (Response)input.read(Response.class);
                    continue block18;
                }
                case "hasExtraInfo": {
                    hasExtraInfo = input.nextBoolean();
                    continue block18;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseReceived(requestId, loaderId, timestamp, type, response, hasExtraInfo, frameId);
    }
}

