package org.openqa.selenium.devtools.v117.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionReportingSourceRegistration {

    private final org.openqa.selenium.devtools.v117.network.model.TimeSinceEpoch time;

    private final java.util.Optional<java.lang.Integer> expiry;

    private final java.util.Optional<java.lang.Integer> eventReportWindow;

    private final java.util.Optional<java.lang.Integer> aggregatableReportWindow;

    private final org.openqa.selenium.devtools.v117.storage.model.AttributionReportingSourceType type;

    private final java.lang.String sourceOrigin;

    private final java.lang.String reportingOrigin;

    private final java.util.List<java.lang.String> destinationSites;

    private final org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10 eventId;

    private final org.openqa.selenium.devtools.v117.storage.model.SignedInt64AsBase10 priority;

    private final java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingFilterDataEntry> filterData;

    private final java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingAggregationKeysEntry> aggregationKeys;

    private final java.util.Optional<org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10> debugKey;

    public AttributionReportingSourceRegistration(org.openqa.selenium.devtools.v117.network.model.TimeSinceEpoch time, java.util.Optional<java.lang.Integer> expiry, java.util.Optional<java.lang.Integer> eventReportWindow, java.util.Optional<java.lang.Integer> aggregatableReportWindow, org.openqa.selenium.devtools.v117.storage.model.AttributionReportingSourceType type, java.lang.String sourceOrigin, java.lang.String reportingOrigin, java.util.List<java.lang.String> destinationSites, org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10 eventId, org.openqa.selenium.devtools.v117.storage.model.SignedInt64AsBase10 priority, java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingFilterDataEntry> filterData, java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingAggregationKeysEntry> aggregationKeys, java.util.Optional<org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10> debugKey) {
        this.time = java.util.Objects.requireNonNull(time, "time is required");
        this.expiry = expiry;
        this.eventReportWindow = eventReportWindow;
        this.aggregatableReportWindow = aggregatableReportWindow;
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.sourceOrigin = java.util.Objects.requireNonNull(sourceOrigin, "sourceOrigin is required");
        this.reportingOrigin = java.util.Objects.requireNonNull(reportingOrigin, "reportingOrigin is required");
        this.destinationSites = java.util.Objects.requireNonNull(destinationSites, "destinationSites is required");
        this.eventId = java.util.Objects.requireNonNull(eventId, "eventId is required");
        this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
        this.filterData = java.util.Objects.requireNonNull(filterData, "filterData is required");
        this.aggregationKeys = java.util.Objects.requireNonNull(aggregationKeys, "aggregationKeys is required");
        this.debugKey = debugKey;
    }

    public org.openqa.selenium.devtools.v117.network.model.TimeSinceEpoch getTime() {
        return time;
    }

    /**
     * duration in seconds
     */
    public java.util.Optional<java.lang.Integer> getExpiry() {
        return expiry;
    }

    /**
     * duration in seconds
     */
    public java.util.Optional<java.lang.Integer> getEventReportWindow() {
        return eventReportWindow;
    }

    /**
     * duration in seconds
     */
    public java.util.Optional<java.lang.Integer> getAggregatableReportWindow() {
        return aggregatableReportWindow;
    }

    public org.openqa.selenium.devtools.v117.storage.model.AttributionReportingSourceType getType() {
        return type;
    }

    public java.lang.String getSourceOrigin() {
        return sourceOrigin;
    }

    public java.lang.String getReportingOrigin() {
        return reportingOrigin;
    }

    public java.util.List<java.lang.String> getDestinationSites() {
        return destinationSites;
    }

    public org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10 getEventId() {
        return eventId;
    }

    public org.openqa.selenium.devtools.v117.storage.model.SignedInt64AsBase10 getPriority() {
        return priority;
    }

    public java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingFilterDataEntry> getFilterData() {
        return filterData;
    }

    public java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingAggregationKeysEntry> getAggregationKeys() {
        return aggregationKeys;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10> getDebugKey() {
        return debugKey;
    }

    private static AttributionReportingSourceRegistration fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v117.network.model.TimeSinceEpoch time = null;
        java.util.Optional<java.lang.Integer> expiry = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> eventReportWindow = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> aggregatableReportWindow = java.util.Optional.empty();
        org.openqa.selenium.devtools.v117.storage.model.AttributionReportingSourceType type = null;
        java.lang.String sourceOrigin = null;
        java.lang.String reportingOrigin = null;
        java.util.List<java.lang.String> destinationSites = null;
        org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10 eventId = null;
        org.openqa.selenium.devtools.v117.storage.model.SignedInt64AsBase10 priority = null;
        java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingFilterDataEntry> filterData = null;
        java.util.List<org.openqa.selenium.devtools.v117.storage.model.AttributionReportingAggregationKeysEntry> aggregationKeys = null;
        java.util.Optional<org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10> debugKey = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "time":
                    time = input.read(org.openqa.selenium.devtools.v117.network.model.TimeSinceEpoch.class);
                    break;
                case "expiry":
                    expiry = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "eventReportWindow":
                    eventReportWindow = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "aggregatableReportWindow":
                    aggregatableReportWindow = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v117.storage.model.AttributionReportingSourceType.class);
                    break;
                case "sourceOrigin":
                    sourceOrigin = input.nextString();
                    break;
                case "reportingOrigin":
                    reportingOrigin = input.nextString();
                    break;
                case "destinationSites":
                    destinationSites = input.readArray(java.lang.String.class);
                    break;
                case "eventId":
                    eventId = input.read(org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10.class);
                    break;
                case "priority":
                    priority = input.read(org.openqa.selenium.devtools.v117.storage.model.SignedInt64AsBase10.class);
                    break;
                case "filterData":
                    filterData = input.readArray(org.openqa.selenium.devtools.v117.storage.model.AttributionReportingFilterDataEntry.class);
                    break;
                case "aggregationKeys":
                    aggregationKeys = input.readArray(org.openqa.selenium.devtools.v117.storage.model.AttributionReportingAggregationKeysEntry.class);
                    break;
                case "debugKey":
                    debugKey = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingSourceRegistration(time, expiry, eventReportWindow, aggregatableReportWindow, type, sourceOrigin, reportingOrigin, destinationSites, eventId, priority, filterData, aggregationKeys, debugKey);
    }
}
