package org.openqa.selenium.devtools.v118.tracing.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Signals that tracing is stopped and there is no trace buffers pending flush, all data were
 * delivered via dataCollected events.
 */
public class TracingComplete {

    private final java.lang.Boolean dataLossOccurred;

    private final java.util.Optional<org.openqa.selenium.devtools.v118.io.model.StreamHandle> stream;

    private final java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamFormat> traceFormat;

    private final java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamCompression> streamCompression;

    public TracingComplete(java.lang.Boolean dataLossOccurred, java.util.Optional<org.openqa.selenium.devtools.v118.io.model.StreamHandle> stream, java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamFormat> traceFormat, java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamCompression> streamCompression) {
        this.dataLossOccurred = java.util.Objects.requireNonNull(dataLossOccurred, "dataLossOccurred is required");
        this.stream = stream;
        this.traceFormat = traceFormat;
        this.streamCompression = streamCompression;
    }

    /**
     * Indicates whether some trace data is known to have been lost, e.g. because the trace ring
     * buffer wrapped around.
     */
    public java.lang.Boolean getDataLossOccurred() {
        return dataLossOccurred;
    }

    /**
     * A handle of the stream that holds resulting trace data.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v118.io.model.StreamHandle> getStream() {
        return stream;
    }

    /**
     * Trace data format of returned stream.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamFormat> getTraceFormat() {
        return traceFormat;
    }

    /**
     * Compression format of returned stream.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamCompression> getStreamCompression() {
        return streamCompression;
    }

    private static TracingComplete fromJson(JsonInput input) {
        java.lang.Boolean dataLossOccurred = false;
        java.util.Optional<org.openqa.selenium.devtools.v118.io.model.StreamHandle> stream = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamFormat> traceFormat = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v118.tracing.model.StreamCompression> streamCompression = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "dataLossOccurred":
                    dataLossOccurred = input.nextBoolean();
                    break;
                case "stream":
                    stream = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v118.io.model.StreamHandle.class));
                    break;
                case "traceFormat":
                    traceFormat = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v118.tracing.model.StreamFormat.class));
                    break;
                case "streamCompression":
                    streamCompression = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v118.tracing.model.StreamCompression.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TracingComplete(dataLossOccurred, stream, traceFormat, streamCompression);
    }
}
