/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v118.css.model.CSSStyle;
import org.openqa.selenium.devtools.v118.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v118.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.v118.css.model.Value;
import org.openqa.selenium.json.JsonInput;

public class CSSKeyframeRule {
    private final Optional<StyleSheetId> styleSheetId;
    private final StyleSheetOrigin origin;
    private final Value keyText;
    private final CSSStyle style;

    public CSSKeyframeRule(Optional<StyleSheetId> styleSheetId, StyleSheetOrigin origin, Value keyText, CSSStyle style) {
        this.styleSheetId = styleSheetId;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.keyText = Objects.requireNonNull(keyText, "keyText is required");
        this.style = Objects.requireNonNull(style, "style is required");
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public Value getKeyText() {
        return this.keyText;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    private static CSSKeyframeRule fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        StyleSheetOrigin origin = null;
        Value keyText = null;
        CSSStyle style = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block12;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block12;
                }
                case "keyText": {
                    keyText = (Value)input.read(Value.class);
                    continue block12;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSKeyframeRule(styleSheetId, origin, keyText, style);
    }
}

