package org.openqa.selenium.devtools.v118.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * List of content encodings supported by the backend.
 */
@org.openqa.selenium.Beta()
public enum ContentEncoding {

    DEFLATE("deflate"), GZIP("gzip"), BR("br"), ZSTD("zstd");

    private String value;

    ContentEncoding(String value) {
        this.value = value;
    }

    public static ContentEncoding fromString(String s) {
        return java.util.Arrays.stream(ContentEncoding.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ContentEncoding "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ContentEncoding fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
