/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.page.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v118.page.model.Frame;
import org.openqa.selenium.json.JsonInput;

public class FrameTree {
    private final Frame frame;
    private final Optional<List<FrameTree>> childFrames;

    public FrameTree(Frame frame, Optional<List<FrameTree>> childFrames) {
        this.frame = Objects.requireNonNull(frame, "frame is required");
        this.childFrames = childFrames;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Optional<List<FrameTree>> getChildFrames() {
        return this.childFrames;
    }

    private static FrameTree fromJson(JsonInput input) {
        Frame frame = null;
        Optional<List<FrameTree>> childFrames = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frame": {
                    frame = (Frame)input.read(Frame.class);
                    continue block8;
                }
                case "childFrames": {
                    childFrames = Optional.ofNullable(input.readArray(FrameTree.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameTree(frame, childFrames);
    }
}

