package org.openqa.selenium.devtools.v120.domsnapshot.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Table containing nodes.
 */
public class NodeTreeSnapshot {

    private final java.util.Optional<java.util.List<java.lang.Integer>> parentIndex;

    private final java.util.Optional<java.util.List<java.lang.Integer>> nodeType;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> shadowRootType;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> nodeName;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> nodeValue;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.dom.model.BackendNodeId>> backendNodeId;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.ArrayOfStrings>> attributes;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> textValue;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> inputValue;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> inputChecked;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> optionSelected;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareIntegerData> contentDocumentIndex;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> pseudoType;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> pseudoIdentifier;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> isClickable;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> currentSourceURL;

    private final java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> originURL;

    public NodeTreeSnapshot(java.util.Optional<java.util.List<java.lang.Integer>> parentIndex, java.util.Optional<java.util.List<java.lang.Integer>> nodeType, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> shadowRootType, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> nodeName, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> nodeValue, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.dom.model.BackendNodeId>> backendNodeId, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.ArrayOfStrings>> attributes, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> textValue, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> inputValue, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> inputChecked, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> optionSelected, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareIntegerData> contentDocumentIndex, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> pseudoType, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> pseudoIdentifier, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> isClickable, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> currentSourceURL, java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> originURL) {
        this.parentIndex = parentIndex;
        this.nodeType = nodeType;
        this.shadowRootType = shadowRootType;
        this.nodeName = nodeName;
        this.nodeValue = nodeValue;
        this.backendNodeId = backendNodeId;
        this.attributes = attributes;
        this.textValue = textValue;
        this.inputValue = inputValue;
        this.inputChecked = inputChecked;
        this.optionSelected = optionSelected;
        this.contentDocumentIndex = contentDocumentIndex;
        this.pseudoType = pseudoType;
        this.pseudoIdentifier = pseudoIdentifier;
        this.isClickable = isClickable;
        this.currentSourceURL = currentSourceURL;
        this.originURL = originURL;
    }

    /**
     * Parent node index.
     */
    public java.util.Optional<java.util.List<java.lang.Integer>> getParentIndex() {
        return parentIndex;
    }

    /**
     * `Node`'s nodeType.
     */
    public java.util.Optional<java.util.List<java.lang.Integer>> getNodeType() {
        return nodeType;
    }

    /**
     * Type of the shadow root the `Node` is in. String values are equal to the `ShadowRootType` enum.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> getShadowRootType() {
        return shadowRootType;
    }

    /**
     * `Node`'s nodeName.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> getNodeName() {
        return nodeName;
    }

    /**
     * `Node`'s nodeValue.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> getNodeValue() {
        return nodeValue;
    }

    /**
     * `Node`'s id, corresponds to DOM.Node.backendNodeId.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.dom.model.BackendNodeId>> getBackendNodeId() {
        return backendNodeId;
    }

    /**
     * Attributes of an `Element` node. Flatten name, value pairs.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.ArrayOfStrings>> getAttributes() {
        return attributes;
    }

    /**
     * Only set for textarea elements, contains the text value.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> getTextValue() {
        return textValue;
    }

    /**
     * Only set for input elements, contains the input's associated text value.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> getInputValue() {
        return inputValue;
    }

    /**
     * Only set for radio and checkbox input elements, indicates if the element has been checked
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> getInputChecked() {
        return inputChecked;
    }

    /**
     * Only set for option elements, indicates if the element has been selected
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> getOptionSelected() {
        return optionSelected;
    }

    /**
     * The index of the document in the list of the snapshot documents.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareIntegerData> getContentDocumentIndex() {
        return contentDocumentIndex;
    }

    /**
     * Type of a pseudo element node.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> getPseudoType() {
        return pseudoType;
    }

    /**
     * Pseudo element identifier for this node. Only present if there is a
     * valid pseudoType.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> getPseudoIdentifier() {
        return pseudoIdentifier;
    }

    /**
     * Whether this DOM node responds to mouse clicks. This includes nodes that have had click
     * event listeners attached via JavaScript as well as anchor tags that naturally navigate when
     * clicked.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> getIsClickable() {
        return isClickable;
    }

    /**
     * The selected url for nodes with a srcset attribute.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> getCurrentSourceURL() {
        return currentSourceURL;
    }

    /**
     * The url of the script (if any) that generates this node.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> getOriginURL() {
        return originURL;
    }

    private static NodeTreeSnapshot fromJson(JsonInput input) {
        java.util.Optional<java.util.List<java.lang.Integer>> parentIndex = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.Integer>> nodeType = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> shadowRootType = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> nodeName = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex>> nodeValue = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.dom.model.BackendNodeId>> backendNodeId = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v120.domsnapshot.model.ArrayOfStrings>> attributes = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> textValue = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> inputValue = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> inputChecked = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> optionSelected = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareIntegerData> contentDocumentIndex = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> pseudoType = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> pseudoIdentifier = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData> isClickable = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> currentSourceURL = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData> originURL = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "parentIndex":
                    parentIndex = java.util.Optional.ofNullable(input.readArray(java.lang.Integer.class));
                    break;
                case "nodeType":
                    nodeType = java.util.Optional.ofNullable(input.readArray(java.lang.Integer.class));
                    break;
                case "shadowRootType":
                    shadowRootType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData.class));
                    break;
                case "nodeName":
                    nodeName = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex.class));
                    break;
                case "nodeValue":
                    nodeValue = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v120.domsnapshot.model.StringIndex.class));
                    break;
                case "backendNodeId":
                    backendNodeId = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v120.dom.model.BackendNodeId.class));
                    break;
                case "attributes":
                    attributes = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v120.domsnapshot.model.ArrayOfStrings.class));
                    break;
                case "textValue":
                    textValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData.class));
                    break;
                case "inputValue":
                    inputValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData.class));
                    break;
                case "inputChecked":
                    inputChecked = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData.class));
                    break;
                case "optionSelected":
                    optionSelected = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData.class));
                    break;
                case "contentDocumentIndex":
                    contentDocumentIndex = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareIntegerData.class));
                    break;
                case "pseudoType":
                    pseudoType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData.class));
                    break;
                case "pseudoIdentifier":
                    pseudoIdentifier = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData.class));
                    break;
                case "isClickable":
                    isClickable = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareBooleanData.class));
                    break;
                case "currentSourceURL":
                    currentSourceURL = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData.class));
                    break;
                case "originURL":
                    originURL = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v120.domsnapshot.model.RareStringData.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new NodeTreeSnapshot(parentIndex, nodeType, shadowRootType, nodeName, nodeValue, backendNodeId, attributes, textValue, inputValue, inputChecked, optionSelected, contentDocumentIndex, pseudoType, pseudoIdentifier, isClickable, currentSourceURL, originURL);
    }
}
