package org.openqa.selenium.devtools.v120.preload;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Preload {

    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Preload.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Preload.disable", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v120.preload.model.RuleSet> ruleSetUpdated() {
        return new Event<>("Preload.ruleSetUpdated", ConverterFunctions.map("ruleSet", org.openqa.selenium.devtools.v120.preload.model.RuleSet.class));
    }

    public static Event<org.openqa.selenium.devtools.v120.preload.model.RuleSetId> ruleSetRemoved() {
        return new Event<>("Preload.ruleSetRemoved", ConverterFunctions.map("id", org.openqa.selenium.devtools.v120.preload.model.RuleSetId.class));
    }

    public static Event<org.openqa.selenium.devtools.v120.preload.model.PreloadEnabledStateUpdated> preloadEnabledStateUpdated() {
        return new Event<>("Preload.preloadEnabledStateUpdated", input -> input.read(org.openqa.selenium.devtools.v120.preload.model.PreloadEnabledStateUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v120.preload.model.PrefetchStatusUpdated> prefetchStatusUpdated() {
        return new Event<>("Preload.prefetchStatusUpdated", input -> input.read(org.openqa.selenium.devtools.v120.preload.model.PrefetchStatusUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v120.preload.model.PrerenderStatusUpdated> prerenderStatusUpdated() {
        return new Event<>("Preload.prerenderStatusUpdated", input -> input.read(org.openqa.selenium.devtools.v120.preload.model.PrerenderStatusUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v120.preload.model.PreloadingAttemptSourcesUpdated> preloadingAttemptSourcesUpdated() {
        return new Event<>("Preload.preloadingAttemptSourcesUpdated", input -> input.read(org.openqa.selenium.devtools.v120.preload.model.PreloadingAttemptSourcesUpdated.class));
    }
}
