package org.openqa.selenium.devtools.v121.eventbreakpoints;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * EventBreakpoints permits setting JavaScript breakpoints on operations and events
 * occurring in native code invoked from JavaScript. Once breakpoint is hit, it is
 * reported through Debugger domain, similarly to regular breakpoints being hit.
 */
@Beta()
public class EventBreakpoints {

    /**
     * Sets breakpoint on particular native event.
     */
    public static Command<Void> setInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        return new Command<>("EventBreakpoints.setInstrumentationBreakpoint", Map.copyOf(params));
    }

    /**
     * Removes breakpoint on particular native event.
     */
    public static Command<Void> removeInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        return new Command<>("EventBreakpoints.removeInstrumentationBreakpoint", Map.copyOf(params));
    }

    /**
     * Removes all breakpoints
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("EventBreakpoints.disable", Map.copyOf(params));
    }
}
