package org.openqa.selenium.devtools.v122.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents options for serialization. Overrides `generatePreview` and `returnByValue`.
 */
public class SerializationOptions {

    public enum Serialization {

        DEEP("deep"), JSON("json"), IDONLY("idOnly");

        private String value;

        Serialization(String value) {
            this.value = value;
        }

        public static Serialization fromString(String s) {
            return java.util.Arrays.stream(Serialization.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Serialization "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Serialization fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Serialization serialization;

    private final java.util.Optional<java.lang.Integer> maxDepth;

    private final java.util.Optional<java.util.Map<String, Object>> additionalParameters;

    public SerializationOptions(Serialization serialization, java.util.Optional<java.lang.Integer> maxDepth, java.util.Optional<java.util.Map<String, Object>> additionalParameters) {
        this.serialization = java.util.Objects.requireNonNull(serialization, "serialization is required");
        this.maxDepth = maxDepth;
        this.additionalParameters = additionalParameters;
    }

    public Serialization getSerialization() {
        return serialization;
    }

    /**
     * Deep serialization depth. Default is full depth. Respected only in `deep` serialization mode.
     */
    public java.util.Optional<java.lang.Integer> getMaxDepth() {
        return maxDepth;
    }

    /**
     * Embedder-specific parameters. For example if connected to V8 in Chrome these control DOM
     * serialization via `maxNodeDepth: integer` and `includeShadowTree: "none" | "open" | "all"`.
     * Values can be only of type string or integer.
     */
    public java.util.Optional<java.util.Map<String, Object>> getAdditionalParameters() {
        return additionalParameters;
    }

    private static SerializationOptions fromJson(JsonInput input) {
        Serialization serialization = null;
        java.util.Optional<java.lang.Integer> maxDepth = java.util.Optional.empty();
        java.util.Optional<java.util.Map<String, Object>> additionalParameters = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "serialization":
                    serialization = Serialization.fromString(input.nextString());
                    break;
                case "maxDepth":
                    maxDepth = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "additionalParameters":
                    additionalParameters = java.util.Optional.ofNullable((java.util.Map<String, Object>) input.read(java.util.Map.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SerializationOptions(serialization, maxDepth, additionalParameters);
    }
}
