package org.openqa.selenium.devtools.v124.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Bundles a candidate URL with its reporting metadata.
 */
public class SharedStorageUrlWithMetadata {

    private final java.lang.String url;

    private final java.util.List<org.openqa.selenium.devtools.v124.storage.model.SharedStorageReportingMetadata> reportingMetadata;

    public SharedStorageUrlWithMetadata(java.lang.String url, java.util.List<org.openqa.selenium.devtools.v124.storage.model.SharedStorageReportingMetadata> reportingMetadata) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.reportingMetadata = java.util.Objects.requireNonNull(reportingMetadata, "reportingMetadata is required");
    }

    /**
     * Spec of candidate URL.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Any associated reporting metadata.
     */
    public java.util.List<org.openqa.selenium.devtools.v124.storage.model.SharedStorageReportingMetadata> getReportingMetadata() {
        return reportingMetadata;
    }

    private static SharedStorageUrlWithMetadata fromJson(JsonInput input) {
        java.lang.String url = null;
        java.util.List<org.openqa.selenium.devtools.v124.storage.model.SharedStorageReportingMetadata> reportingMetadata = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "reportingMetadata":
                    reportingMetadata = input.readArray(org.openqa.selenium.devtools.v124.storage.model.SharedStorageReportingMetadata.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageUrlWithMetadata(url, reportingMetadata);
    }
}
