/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.backgroundservice;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v124.backgroundservice.model.BackgroundServiceEvent;
import org.openqa.selenium.devtools.v124.backgroundservice.model.RecordingStateChanged;
import org.openqa.selenium.devtools.v124.backgroundservice.model.ServiceName;

@Beta
public class BackgroundService {
    public static Command<Void> startObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, ServiceName> params = new LinkedHashMap<String, ServiceName>();
        params.put("service", service);
        return new Command("BackgroundService.startObserving", Map.copyOf(params));
    }

    public static Command<Void> stopObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, ServiceName> params = new LinkedHashMap<String, ServiceName>();
        params.put("service", service);
        return new Command("BackgroundService.stopObserving", Map.copyOf(params));
    }

    public static Command<Void> setRecording(Boolean shouldRecord, ServiceName service) {
        Objects.requireNonNull(shouldRecord, "shouldRecord is required");
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("shouldRecord", shouldRecord);
        params.put("service", (Object)service);
        return new Command("BackgroundService.setRecording", Map.copyOf(params));
    }

    public static Command<Void> clearEvents(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, ServiceName> params = new LinkedHashMap<String, ServiceName>();
        params.put("service", service);
        return new Command("BackgroundService.clearEvents", Map.copyOf(params));
    }

    public static Event<RecordingStateChanged> recordingStateChanged() {
        return new Event("BackgroundService.recordingStateChanged", input -> (RecordingStateChanged)input.read(RecordingStateChanged.class));
    }

    public static Event<BackgroundServiceEvent> backgroundServiceEventReceived() {
        return new Event("BackgroundService.backgroundServiceEventReceived", ConverterFunctions.map((String)"backgroundServiceEvent", BackgroundServiceEvent.class));
    }
}

