package org.openqa.selenium.devtools.v125.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class Shortcut {

    private final java.lang.String name;

    private final java.lang.String url;

    public Shortcut(java.lang.String name, java.lang.String url) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
    }

    public java.lang.String getName() {
        return name;
    }

    public java.lang.String getUrl() {
        return url;
    }

    private static Shortcut fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.String url = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "url":
                    url = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Shortcut(name, url);
    }
}
