package org.openqa.selenium.devtools.v125.accessibility;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Accessibility {

    /**
     * Disables the accessibility domain.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Accessibility.disable", Map.copyOf(params));
    }

    /**
     * Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls.
     * This turns on accessibility for the page, which can impact performance until accessibility is disabled.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Accessibility.enable", Map.copyOf(params));
    }

    /**
     * Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v125.accessibility.model.AXNode>> getPartialAXTree(java.util.Optional<org.openqa.selenium.devtools.v125.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v125.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v125.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.lang.Boolean> fetchRelatives) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        fetchRelatives.ifPresent(p -> params.put("fetchRelatives", p));
        return new Command<>("Accessibility.getPartialAXTree", Map.copyOf(params), ConverterFunctions.map("nodes", input -> input.readArray(org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class)));
    }

    /**
     * Fetches the entire accessibility tree for the root Document
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v125.accessibility.model.AXNode>> getFullAXTree(java.util.Optional<java.lang.Integer> depth, java.util.Optional<org.openqa.selenium.devtools.v125.page.model.FrameId> frameId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        depth.ifPresent(p -> params.put("depth", p));
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<>("Accessibility.getFullAXTree", Map.copyOf(params), ConverterFunctions.map("nodes", input -> input.readArray(org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class)));
    }

    /**
     * Fetches the root node.
     * Requires `enable()` to have been called previously.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v125.accessibility.model.AXNode> getRootAXNode(java.util.Optional<org.openqa.selenium.devtools.v125.page.model.FrameId> frameId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<>("Accessibility.getRootAXNode", Map.copyOf(params), ConverterFunctions.map("node", org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class));
    }

    /**
     * Fetches a node and all ancestors up to and including the root.
     * Requires `enable()` to have been called previously.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v125.accessibility.model.AXNode>> getAXNodeAndAncestors(java.util.Optional<org.openqa.selenium.devtools.v125.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v125.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v125.runtime.model.RemoteObjectId> objectId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<>("Accessibility.getAXNodeAndAncestors", Map.copyOf(params), ConverterFunctions.map("nodes", input -> input.readArray(org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class)));
    }

    /**
     * Fetches a particular accessibility node by AXNodeId.
     * Requires `enable()` to have been called previously.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v125.accessibility.model.AXNode>> getChildAXNodes(org.openqa.selenium.devtools.v125.accessibility.model.AXNodeId id, java.util.Optional<org.openqa.selenium.devtools.v125.page.model.FrameId> frameId) {
        java.util.Objects.requireNonNull(id, "id is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<>("Accessibility.getChildAXNodes", Map.copyOf(params), ConverterFunctions.map("nodes", input -> input.readArray(org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class)));
    }

    /**
     * Query a DOM node's accessibility subtree for accessible name and role.
     * This command computes the name and role for all nodes in the subtree, including those that are
     * ignored for accessibility, and returns those that match the specified name and role. If no DOM
     * node is specified, or the DOM node does not exist, the command returns an error. If neither
     * `accessibleName` or `role` is specified, it returns all the accessibility nodes in the subtree.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v125.accessibility.model.AXNode>> queryAXTree(java.util.Optional<org.openqa.selenium.devtools.v125.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v125.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v125.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.lang.String> accessibleName, java.util.Optional<java.lang.String> role) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        accessibleName.ifPresent(p -> params.put("accessibleName", p));
        role.ifPresent(p -> params.put("role", p));
        return new Command<>("Accessibility.queryAXTree", Map.copyOf(params), ConverterFunctions.map("nodes", input -> input.readArray(org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class)));
    }

    public static Event<org.openqa.selenium.devtools.v125.accessibility.model.AXNode> loadComplete() {
        return new Event<>("Accessibility.loadComplete", ConverterFunctions.map("root", org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class));
    }

    public static Event<java.util.List<org.openqa.selenium.devtools.v125.accessibility.model.AXNode>> nodesUpdated() {
        return new Event<>("Accessibility.nodesUpdated", ConverterFunctions.map("nodes", input -> input.readArray(org.openqa.selenium.devtools.v125.accessibility.model.AXNode.class)));
    }
}
