package org.openqa.selenium.devtools.v125.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints
 */
@org.openqa.selenium.Beta()
public class UserAgentBrandVersion {

    private final java.lang.String brand;

    private final java.lang.String version;

    public UserAgentBrandVersion(java.lang.String brand, java.lang.String version) {
        this.brand = java.util.Objects.requireNonNull(brand, "brand is required");
        this.version = java.util.Objects.requireNonNull(version, "version is required");
    }

    public java.lang.String getBrand() {
        return brand;
    }

    public java.lang.String getVersion() {
        return version;
    }

    private static UserAgentBrandVersion fromJson(JsonInput input) {
        java.lang.String brand = null;
        java.lang.String version = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "brand":
                    brand = input.nextString();
                    break;
                case "version":
                    version = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new UserAgentBrandVersion(brand, version);
    }
}
