package org.openqa.selenium.devtools.v127.inspector;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Inspector {

    /**
     * Disables inspector domain notifications.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Inspector.disable", Map.copyOf(params));
    }

    /**
     * Enables inspector domain notifications.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Inspector.enable", Map.copyOf(params));
    }

    public static Event<java.lang.String> detached() {
        return new Event<>("Inspector.detached", ConverterFunctions.map("reason", java.lang.String.class));
    }

    public static Event<Void> targetCrashed() {
        return new Event<>("Inspector.targetCrashed", ConverterFunctions.empty());
    }

    public static Event<Void> targetReloadedAfterCrash() {
        return new Event<>("Inspector.targetReloadedAfterCrash", ConverterFunctions.empty());
    }
}
