package org.openqa.selenium.devtools.v132.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum PressureSource {

    CPU("cpu");

    private String value;

    PressureSource(String value) {
        this.value = value;
    }

    public static PressureSource fromString(String s) {
        return java.util.Arrays.stream(PressureSource.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PressureSource "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PressureSource fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
