package org.openqa.selenium.devtools.v134.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class FileHandler {

    private final java.lang.String action;

    private final java.lang.String name;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.ImageResource>> icons;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.FileFilter>> accepts;

    private final java.lang.String launchType;

    public FileHandler(java.lang.String action, java.lang.String name, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.ImageResource>> icons, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.FileFilter>> accepts, java.lang.String launchType) {
        this.action = java.util.Objects.requireNonNull(action, "action is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.icons = icons;
        this.accepts = accepts;
        this.launchType = java.util.Objects.requireNonNull(launchType, "launchType is required");
    }

    public java.lang.String getAction() {
        return action;
    }

    public java.lang.String getName() {
        return name;
    }

    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.ImageResource>> getIcons() {
        return icons;
    }

    /**
     * Mimic a map, name is the key, accepts is the value.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.FileFilter>> getAccepts() {
        return accepts;
    }

    /**
     * Won't repeat the enums, using string for easy comparison. Same as the
     * other enums below.
     */
    public java.lang.String getLaunchType() {
        return launchType;
    }

    private static FileHandler fromJson(JsonInput input) {
        java.lang.String action = null;
        java.lang.String name = null;
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.ImageResource>> icons = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.page.model.FileFilter>> accepts = java.util.Optional.empty();
        java.lang.String launchType = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "action":
                    action = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "icons":
                    icons = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v134.page.model.ImageResource.class));
                    break;
                case "accepts":
                    accepts = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v134.page.model.FileFilter.class));
                    break;
                case "launchType":
                    launchType = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FileHandler(action, name, icons, accepts, launchType);
    }
}
