package org.openqa.selenium.devtools.v136.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Describes the properties of a characteristic. This follows Bluetooth Core
 * Specification BT 4.2 Vol 3 Part G 3.3.1. Characteristic Properties.
 */
public class CharacteristicProperties {

    private final java.util.Optional<java.lang.Boolean> broadcast;

    private final java.util.Optional<java.lang.Boolean> read;

    private final java.util.Optional<java.lang.Boolean> writeWithoutResponse;

    private final java.util.Optional<java.lang.Boolean> write;

    private final java.util.Optional<java.lang.Boolean> notify;

    private final java.util.Optional<java.lang.Boolean> indicate;

    private final java.util.Optional<java.lang.Boolean> authenticatedSignedWrites;

    private final java.util.Optional<java.lang.Boolean> extendedProperties;

    public CharacteristicProperties(java.util.Optional<java.lang.Boolean> broadcast, java.util.Optional<java.lang.Boolean> read, java.util.Optional<java.lang.Boolean> writeWithoutResponse, java.util.Optional<java.lang.Boolean> write, java.util.Optional<java.lang.Boolean> notify, java.util.Optional<java.lang.Boolean> indicate, java.util.Optional<java.lang.Boolean> authenticatedSignedWrites, java.util.Optional<java.lang.Boolean> extendedProperties) {
        this.broadcast = broadcast;
        this.read = read;
        this.writeWithoutResponse = writeWithoutResponse;
        this.write = write;
        this.notify = notify;
        this.indicate = indicate;
        this.authenticatedSignedWrites = authenticatedSignedWrites;
        this.extendedProperties = extendedProperties;
    }

    public java.util.Optional<java.lang.Boolean> getBroadcast() {
        return broadcast;
    }

    public java.util.Optional<java.lang.Boolean> getRead() {
        return read;
    }

    public java.util.Optional<java.lang.Boolean> getWriteWithoutResponse() {
        return writeWithoutResponse;
    }

    public java.util.Optional<java.lang.Boolean> getWrite() {
        return write;
    }

    public java.util.Optional<java.lang.Boolean> getNotify() {
        return notify;
    }

    public java.util.Optional<java.lang.Boolean> getIndicate() {
        return indicate;
    }

    public java.util.Optional<java.lang.Boolean> getAuthenticatedSignedWrites() {
        return authenticatedSignedWrites;
    }

    public java.util.Optional<java.lang.Boolean> getExtendedProperties() {
        return extendedProperties;
    }

    private static CharacteristicProperties fromJson(JsonInput input) {
        java.util.Optional<java.lang.Boolean> broadcast = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> read = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> writeWithoutResponse = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> write = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> notify = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> indicate = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> authenticatedSignedWrites = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> extendedProperties = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "broadcast":
                    broadcast = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "read":
                    read = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "writeWithoutResponse":
                    writeWithoutResponse = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "write":
                    write = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "notify":
                    notify = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "indicate":
                    indicate = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "authenticatedSignedWrites":
                    authenticatedSignedWrites = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "extendedProperties":
                    extendedProperties = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CharacteristicProperties(broadcast, read, writeWithoutResponse, write, notify, indicate, authenticatedSignedWrites, extendedProperties);
    }
}
