package org.openqa.selenium.devtools.v136.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Have one type per entry in MediaLogRecord::Type
 * Corresponds to kMessage
 */
public class PlayerMessage {

    public enum Level {

        ERROR("error"), WARNING("warning"), INFO("info"), DEBUG("debug");

        private String value;

        Level(String value) {
            this.value = value;
        }

        public static Level fromString(String s) {
            return java.util.Arrays.stream(Level.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Level "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Level fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Level level;

    private final java.lang.String message;

    public PlayerMessage(Level level, java.lang.String message) {
        this.level = java.util.Objects.requireNonNull(level, "level is required");
        this.message = java.util.Objects.requireNonNull(message, "message is required");
    }

    /**
     * Keep in sync with MediaLogMessageLevel
     * We are currently keeping the message level 'error' separate from the
     * PlayerError type because right now they represent different things,
     * this one being a DVLOG(ERROR) style log message that gets printed
     * based on what log level is selected in the UI, and the other is a
     * representation of a media::PipelineStatus object. Soon however we're
     * going to be moving away from using PipelineStatus for errors and
     * introducing a new error type which should hopefully let us integrate
     * the error log level into the PlayerError type.
     */
    public Level getLevel() {
        return level;
    }

    public java.lang.String getMessage() {
        return message;
    }

    private static PlayerMessage fromJson(JsonInput input) {
        Level level = null;
        java.lang.String message = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "level":
                    level = Level.fromString(input.nextString());
                    break;
                case "message":
                    message = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PlayerMessage(level, message);
    }
}
