package org.openqa.selenium.devtools.v136.memory.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * DOM object counter data.
 */
public class DOMCounter {

    private final java.lang.String name;

    private final java.lang.Integer count;

    public DOMCounter(java.lang.String name, java.lang.Integer count) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.count = java.util.Objects.requireNonNull(count, "count is required");
    }

    /**
     * Object name. Note: object names should be presumed volatile and clients should not expect
     * the returned names to be consistent across runs.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Object count.
     */
    public java.lang.Integer getCount() {
        return count;
    }

    private static DOMCounter fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.Integer count = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "count":
                    count = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DOMCounter(name, count);
    }
}
