package org.openqa.selenium.devtools.v136.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates whether the frame is cross-origin isolated and why it is the case.
 */
@org.openqa.selenium.Beta()
public enum CrossOriginIsolatedContextType {

    ISOLATED("Isolated"), NOTISOLATED("NotIsolated"), NOTISOLATEDFEATUREDISABLED("NotIsolatedFeatureDisabled");

    private String value;

    CrossOriginIsolatedContextType(String value) {
        this.value = value;
    }

    public static CrossOriginIsolatedContextType fromString(String s) {
        return java.util.Arrays.stream(CrossOriginIsolatedContextType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CrossOriginIsolatedContextType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CrossOriginIsolatedContextType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
