package org.openqa.selenium.devtools.v136.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Mirror object referencing original JavaScript object.
 */
public class RemoteObject {

    public enum Type {

        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol"),
        BIGINT("bigint");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    public enum Subtype {

        ARRAY("array"),
        NULL("null"),
        NODE("node"),
        REGEXP("regexp"),
        DATE("date"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ITERATOR("iterator"),
        GENERATOR("generator"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPEDARRAY("typedarray"),
        ARRAYBUFFER("arraybuffer"),
        DATAVIEW("dataview"),
        WEBASSEMBLYMEMORY("webassemblymemory"),
        WASMVALUE("wasmvalue");

        private String value;

        Subtype(String value) {
            this.value = value;
        }

        public static Subtype fromString(String s) {
            return java.util.Arrays.stream(Subtype.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Subtype "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Subtype fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Type type;

    private final java.util.Optional<Subtype> subtype;

    private final java.util.Optional<java.lang.String> className;

    private final java.util.Optional<java.lang.Object> value;

    private final java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.UnserializableValue> unserializableValue;

    private final java.util.Optional<java.lang.String> description;

    private final java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.DeepSerializedValue> deepSerializedValue;

    private final java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.RemoteObjectId> objectId;

    private final java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.ObjectPreview> preview;

    private final java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.CustomPreview> customPreview;

    public RemoteObject(Type type, java.util.Optional<Subtype> subtype, java.util.Optional<java.lang.String> className, java.util.Optional<java.lang.Object> value, java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.UnserializableValue> unserializableValue, java.util.Optional<java.lang.String> description, java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.DeepSerializedValue> deepSerializedValue, java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.RemoteObjectId> objectId, java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.ObjectPreview> preview, java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.CustomPreview> customPreview) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.subtype = subtype;
        this.className = className;
        this.value = value;
        this.unserializableValue = unserializableValue;
        this.description = description;
        this.deepSerializedValue = deepSerializedValue;
        this.objectId = objectId;
        this.preview = preview;
        this.customPreview = customPreview;
    }

    /**
     * Object type.
     */
    public Type getType() {
        return type;
    }

    /**
     * Object subtype hint. Specified for `object` type values only.
     * NOTE: If you change anything here, make sure to also update
     * `subtype` in `ObjectPreview` and `PropertyPreview` below.
     */
    public java.util.Optional<Subtype> getSubtype() {
        return subtype;
    }

    /**
     * Object class (constructor) name. Specified for `object` type values only.
     */
    public java.util.Optional<java.lang.String> getClassName() {
        return className;
    }

    /**
     * Remote object value in case of primitive values or JSON values (if it was requested).
     */
    public java.util.Optional<java.lang.Object> getValue() {
        return value;
    }

    /**
     * Primitive value which can not be JSON-stringified does not have `value`, but gets this
     * property.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.UnserializableValue> getUnserializableValue() {
        return unserializableValue;
    }

    /**
     * String representation of the object.
     */
    public java.util.Optional<java.lang.String> getDescription() {
        return description;
    }

    /**
     * Deep serialized value.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.DeepSerializedValue> getDeepSerializedValue() {
        return deepSerializedValue;
    }

    /**
     * Unique object identifier (for non-primitive values).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.RemoteObjectId> getObjectId() {
        return objectId;
    }

    /**
     * Preview containing abbreviated property values. Specified for `object` type values only.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.ObjectPreview> getPreview() {
        return preview;
    }

    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.CustomPreview> getCustomPreview() {
        return customPreview;
    }

    private static RemoteObject fromJson(JsonInput input) {
        Type type = null;
        java.util.Optional<Subtype> subtype = java.util.Optional.empty();
        java.util.Optional<java.lang.String> className = java.util.Optional.empty();
        java.util.Optional<java.lang.Object> value = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.UnserializableValue> unserializableValue = java.util.Optional.empty();
        java.util.Optional<java.lang.String> description = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.DeepSerializedValue> deepSerializedValue = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.RemoteObjectId> objectId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.ObjectPreview> preview = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v136.runtime.model.CustomPreview> customPreview = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = Type.fromString(input.nextString());
                    break;
                case "subtype":
                    subtype = java.util.Optional.ofNullable(Subtype.fromString(input.nextString()));
                    break;
                case "className":
                    className = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.read(Object.class));
                    break;
                case "unserializableValue":
                    unserializableValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.runtime.model.UnserializableValue.class));
                    break;
                case "description":
                    description = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "deepSerializedValue":
                    deepSerializedValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.runtime.model.DeepSerializedValue.class));
                    break;
                case "objectId":
                    objectId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.runtime.model.RemoteObjectId.class));
                    break;
                case "preview":
                    preview = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.runtime.model.ObjectPreview.class));
                    break;
                case "customPreview":
                    customPreview = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.runtime.model.CustomPreview.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RemoteObject(type, subtype, className, value, unserializableValue, description, deepSerializedValue, objectId, preview, customPreview);
    }
}
