/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.runtime.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class DeepSerializedValue {
    private final Type type;
    private final Optional<Object> value;
    private final Optional<String> objectId;
    private final Optional<Integer> weakLocalObjectReference;

    public DeepSerializedValue(Type type, Optional<Object> value, Optional<String> objectId, Optional<Integer> weakLocalObjectReference) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.objectId = objectId;
        this.weakLocalObjectReference = weakLocalObjectReference;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Object> getValue() {
        return this.value;
    }

    public Optional<String> getObjectId() {
        return this.objectId;
    }

    public Optional<Integer> getWeakLocalObjectReference() {
        return this.weakLocalObjectReference;
    }

    private static DeepSerializedValue fromJson(JsonInput input) {
        Type type = null;
        Optional<Object> value = Optional.empty();
        Optional<String> objectId = Optional.empty();
        Optional<Integer> weakLocalObjectReference = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block12;
                }
                case "value": {
                    value = Optional.ofNullable(input.read(Object.class));
                    continue block12;
                }
                case "objectId": {
                    objectId = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "weakLocalObjectReference": {
                    weakLocalObjectReference = Optional.ofNullable(input.nextNumber().intValue());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeepSerializedValue(type, value, objectId, weakLocalObjectReference);
    }

    public static enum Type {
        UNDEFINED("undefined"),
        NULL("null"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        BIGINT("bigint"),
        REGEXP("regexp"),
        DATE("date"),
        SYMBOL("symbol"),
        ARRAY("array"),
        OBJECT("object"),
        FUNCTION("function"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPEDARRAY("typedarray"),
        ARRAYBUFFER("arraybuffer"),
        NODE("node"),
        WINDOW("window"),
        GENERATOR("generator");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

