package org.openqa.selenium.devtools.v136.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS function argument representation.
 */
public class CSSFunctionParameter {

    private final java.lang.String name;

    private final java.lang.String type;

    public CSSFunctionParameter(java.lang.String name, java.lang.String type) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
    }

    /**
     * The parameter name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * The parameter type.
     */
    public java.lang.String getType() {
        return type;
    }

    private static CSSFunctionParameter fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.String type = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "type":
                    type = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSFunctionParameter(name, type);
    }
}
