package org.openqa.selenium.devtools.v137.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration for Window Controls Overlay
 */
public class WindowControlsOverlayConfig {

    private final java.lang.Boolean showCSS;

    private final java.lang.String selectedPlatform;

    private final java.lang.String themeColor;

    public WindowControlsOverlayConfig(java.lang.Boolean showCSS, java.lang.String selectedPlatform, java.lang.String themeColor) {
        this.showCSS = java.util.Objects.requireNonNull(showCSS, "showCSS is required");
        this.selectedPlatform = java.util.Objects.requireNonNull(selectedPlatform, "selectedPlatform is required");
        this.themeColor = java.util.Objects.requireNonNull(themeColor, "themeColor is required");
    }

    /**
     * Whether the title bar CSS should be shown when emulating the Window Controls Overlay.
     */
    public java.lang.Boolean getShowCSS() {
        return showCSS;
    }

    /**
     * Selected platforms to show the overlay.
     */
    public java.lang.String getSelectedPlatform() {
        return selectedPlatform;
    }

    /**
     * The theme color defined in app manifest.
     */
    public java.lang.String getThemeColor() {
        return themeColor;
    }

    private static WindowControlsOverlayConfig fromJson(JsonInput input) {
        java.lang.Boolean showCSS = false;
        java.lang.String selectedPlatform = null;
        java.lang.String themeColor = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "showCSS":
                    showCSS = input.nextBoolean();
                    break;
                case "selectedPlatform":
                    selectedPlatform = input.nextString();
                    break;
                case "themeColor":
                    themeColor = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WindowControlsOverlayConfig(showCSS, selectedPlatform, themeColor);
    }
}
